@echo off
cd /d "%~dp0"

:: Lecture de AppConfig.txt
if not exist "AppConfig.txt" (
    echo ERREUR: AppConfig.txt introuvable.
    pause
    exit /b
)

for /f "usebackq tokens=1,* delims= " %%A in ("AppConfig.txt") do (
    set "EXE_NAME=%%A"
    set "ARGS=%%B"
    goto :read_done
)

:read_done
set PROCESS_NAME=%EXE_NAME:.exe=%

:: Mise a jour de l'Orchestrateur
powershell -NoProfile -Command "(Get-Content config.ini) -replace '^ProcessToMonitor=.*', 'ProcessToMonitor=%PROCESS_NAME%' | Set-Content config.ini"

:: Lancement (Chemin relatif 2 niveaux plus haut pour le cas standard)
pushd "%~dp0..\.."
set "APP_ROOT=%CD%"
popd

start "Lancement %PROCESS_NAME%" /MIN /D "%APP_ROOT%" "%APP_ROOT%\%EXE_NAME%" %ARGS%
